#!/bin/bash

# ejectmedia.sh
#
# Usage: ejectmedia.sh <device file> <log file>
#
# device file: the device file for the device 
#
# Return Codes:
# 1 - Error ejecting the media
#
# Author: C. Schuck

DEVICEFILE=$1
LOGFILE=$2

echo "-> ejectmedia.sh" >> $LOGFILE
echo "Ejecting the media at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> ejectmedia.sh"
actzTrace "XMDA   F: ejectmedia.sh: Ejecting the media at $DEVICEFILE for `date`"

# Eject the media
if ! eject -v $DEVICEFILE >> $LOGFILE 2>&1; then
    echo "Couldn't eject the media...exiting" >> $LOGFILE
    actzTrace "XMDA   F: ejectmedia.sh: Couldn't eject the media...exiting";
    exit 1
fi

actzTrace "XMDA   T: <- ejectmedia.sh"
echo "<- ejectmedia.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0

